package com.ejie.ab04b.dao;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.model.TareaAperturas;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * TareaAperturasDao generated by UDA, 02-Feb-2017 13:49:16.
 * 
 * @author UDA
 */

public interface TareaAperturasDao {

	/**
	 * Inserts a single row in the TareaAperturas table.
	 * 
	 *  tareaAperturas
	 *            TareaAperturas
	 *  TareaAperturas
	 *
	 * @param tareaAperturas the tarea aperturas
	 * @return the tarea aperturas
	 */
	TareaAperturas add(TareaAperturas tareaAperturas);

	/**
	 * Updates a single row in the TareaAperturas table.
	 * 
	 *  tareaAperturas
	 *            TareaAperturas
	 *  TareaAperturas
	 *
	 * @param tareaAperturas the tarea aperturas
	 * @return the tarea aperturas
	 */
	TareaAperturas update(TareaAperturas tareaAperturas);

	/**
	 * Updates a single row in the Expedientes table.
	 * 
	 *  tarea
	 *            TareaAperturas
	 *  TareaAperturas
	 *
	 * @param tarea the tarea
	 * @return the tarea aperturas
	 */
	public TareaAperturas updateFilled(TareaAperturas tarea);

	/**
	 * Finds a single row in the TareaAperturas table.
	 * 
	 *  tareaAperturas
	 *            TareaAperturas
	 *  TareaAperturas
	 *
	 * @param tareaAperturas the tarea aperturas
	 * @return the tarea aperturas
	 */
	TareaAperturas find(TareaAperturas tareaAperturas);

	/**
	 * Finds a single row in the TareaAperturas table.
	 * 
	 *  mailboxTaskId the mailbox task id
	 *  TareaAperturas
	 *
	 * @param mailboxTaskId the mailbox task id
	 * @return the tarea aperturas
	 */
	@Transactional(readOnly = true)
	public TareaAperturas findByMailboxTaskId(String mailboxTaskId);

	/**
	 * Removes a single row in the TareaAperturas table.
	 * 
	 *  tareaAperturas
	 *            TareaAperturas
	 *
	 * @param tareaAperturas the tarea aperturas
	 */
	void remove(TareaAperturas tareaAperturas);

	/**
	 * Finds a List of rows in the TareaAperturas table.
	 * 
	 *  tareaAperturas
	 *            TareaAperturas
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List
	 *
	 * @param tareaAperturas the tarea aperturas
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	List<TareaAperturas> findAll(TareaAperturas tareaAperturas,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Finds rows in the TareaAperturas table using like.
	 * 
	 *  tareaAperturas
	 *            TareaAperturas
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List
	 *
	 * @param tareaAperturas the tarea aperturas
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	List<TareaAperturas> findAllLike(TareaAperturas tareaAperturas,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the TareaAperturas table using like.
	 * 
	 *  tareaAperturas
	 *            TareaAperturas
	 *  startsWith
	 *            Boolean
	 *  Long
	 *
	 * @param tareaAperturas the tarea aperturas
	 * @param startsWith the starts with
	 * @return the long
	 */
	Long findAllLikeCount(TareaAperturas tareaAperturas, Boolean startsWith);

	/**
	 * Counts rows in the TareaAperturas table.
	 * 
	 *  tareaAperturas
	 *            TareaAperturas
	 *  Long
	 *
	 * @param tareaAperturas the tarea aperturas
	 * @return the long
	 */
	Long findAllCount(TareaAperturas tareaAperturas);

	/**
	 * Reorder selection.
	 * 
	 *  filterTareaAperturas
	 *            TareaAperturas
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<TareaAperturas>>
	 *
	 * @param filterTareaAperturas the filter tarea aperturas
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	List<TableRowDto<TareaAperturas>> reorderSelection(
			TareaAperturas filterTareaAperturas,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Searches in the Usuario table.
	 * 
	 *  filterTareaAperturas
	 *            TareaAperturas
	 *  searchTareaAperturas
	 *            TareaAperturas
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<TareaAperturas>>
	 *
	 * @param filterTareaAperturas the filter tarea aperturas
	 * @param searchTareaAperturas the search tarea aperturas
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	List<TableRowDto<TareaAperturas>> search(
			TareaAperturas filterTareaAperturas,
			TareaAperturas searchTareaAperturas,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

}
